package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.Centroj73Dao;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.Centroj73;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Centroj73ServiceImpl generated by UDA, 25-abr-2016 19:06:27.
 * 
 * @author UDA
 */

@Service(value = "centroj73Service")
public class Centroj73ServiceImpl implements Centroj73Service {

	@Autowired()
	private Centroj73Dao centroj73Dao;

	/**
	 * Inserts a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Centroj73 add(Centroj73 centroj73) {
		return this.centroj73Dao.add(centroj73);
	}

	/**
	 * Inserts a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 idUser String Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @param idUser
	 *            the id user
	 * @return the centroj 73
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Centroj73 addCentroJ73(Centroj73 centroj73, String idUser)
			throws AB04BException {
		try {
			Centroj73 centroAux = this.centroj73Dao.addCentroJ73(centroj73,
					idUser);

			return this.centroj73Dao.findCentroAlta(centroAux);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Updates a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Centroj73 update(Centroj73 centroj73) {
		return this.centroj73Dao.update(centroj73);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	public Centroj73 find(Centroj73 centroj73) {
		return (Centroj73) this.centroj73Dao.find(centroj73);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	public Centroj73 findConsultaCentro(Centroj73 centroj73) {
		return (Centroj73) this.centroj73Dao.findConsultaCentro(centroj73);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	public Centroj73 findConsultaNuevoCentro(Centroj73 centroj73) {
		return (Centroj73) this.centroj73Dao.findConsultaNuevoCentro(centroj73);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	public Centroj73 findByCif(Centroj73 centroj73) {
		return (Centroj73) this.centroj73Dao.findByCif(centroj73);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	public Centroj73 findByExpdte(Centroj73 centroj73) {
		return (Centroj73) this.centroj73Dao.findByExpdte(centroj73);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	public Centroj73 findByExpdteFicha(Centroj73 centroj73) {
		return (Centroj73) this.centroj73Dao.findByExpdteFicha(centroj73);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the list
	 */
	public List<Centroj73> findByCifTHRSoc(Centroj73 centroj73) {
		return (List<Centroj73>) this.centroj73Dao.findByCifTHRSoc(centroj73);
	}

	/**
	 * Finds a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @return the centroj 73
	 */
	public Centroj73 findByExpdteHuelga(Centroj73 centroj73) {
		return (Centroj73) this.centroj73Dao.findByExpdteHuelga(centroj73);
	}

	/**
	 * Deletes a single row in the Centroj73 table.
	 * 
	 * centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Centroj73 centroj73) {
		this.centroj73Dao.remove(centroj73);
	}

	/**
	 * Finds a list of rows in the Centroj73 table.
	 * 
	 * centroj73 Centroj73 jqGridRequestDto JQGridRequestDto List<Centroj73>
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<Centroj73> findAll(Centroj73 centroj73,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Centroj73>) this.centroj73Dao.findAll(centroj73,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Centroj73 table using like.
	 * 
	 * centroj73 Centroj73 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Centroj73>
	 * 
	 * @param centroj73
	 *            the centroj 73
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<Centroj73> findAllLike(Centroj73 centroj73,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Centroj73>) this.centroj73Dao.findAllLike(centroj73,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Centroj73 table.
	 * 
	 * filterCentroj73 Centroj73 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<Centroj73>
	 * 
	 * @param filterCentroj73
	 *            the filter centroj 73
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Centroj73> filter(Centroj73 filterCentroj73,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Centroj73> listaCentroj73 = this.centroj73Dao.findAllLike(
				filterCentroj73, jqGridRequestDto, false);
		Long recordNum = this.centroj73Dao.findAllLikeCount(
				filterCentroj73 != null ? filterCentroj73 : new Centroj73(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Centroj73>> reorderSelection = this.centroj73Dao
					.reorderSelection(filterCentroj73, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Centroj73>(jqGridRequestDto,
					recordNum, listaCentroj73, reorderSelection);
		}
		return new JQGridResponseDto<Centroj73>(jqGridRequestDto, recordNum,
				listaCentroj73);
	}

	/**
	 * Reorder the selection made in Centroj73 table.
	 * 
	 * filterCentroj73 Centroj73 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean Object
	 * 
	 * @param filterCentroj73
	 *            the filter centroj 73
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	public Object reorderSelection(Centroj73 filterCentroj73,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.centroj73Dao.reorderSelection(filterCentroj73,
				jqGridRequestDto, startsWith);
	}

}
